﻿
Partial Class signup
    Inherits System.Web.UI.Page

    'page header - declares constants used in the code
    'create an instance of the site infor class to store important data about the site
    Dim ThisSite As New SiteInfo
    'this constant is used to test if no item has been selected in the list
    Const NO_ITEM As Integer = -1
    'used to store the details of the current user
    Dim TheCurrentUser As New SwapShopUser

    'this variable is used to store the password for a new account
    Dim NewPassword As String

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        'if this is the first time the page has loaded
        If IsPostBack = False Then
            'generate a password for the new account
            NewPassword = GeneratePassword()
            'get the site info
            ThisSite = Session("ThisSite")
        Else
            'if it is a page reload then get the already existing password from the session object
            NewPassword = Session("NewPassword")
        End If
    End Sub

    Protected Sub Page_Unload(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Unload
        'save the password on page unload in the session object
        Session("NewPassword") = NewPassword
    End Sub

    Protected Sub btnPassword_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnPassword.Click
        'this event sends a password for the new account once all of the details are validated for the 
        'new user
        '
        'var to store the first name
        Dim FirstName As String
        'var to store the last name
        Dim LastName As String
        'var to store the email address
        Dim EMail As String
        'var to store any error messages
        Dim ErrorMessage As String
        'var to flag successful send of password
        Dim PasswordSent As Boolean
        'clear the error message label
        lblError.Text = ""
        'check to make sure the data is valid
        ErrorMessage = DetailsValid()
        'if no error message created by the above line
        If ErrorMessage = "" Then
            'get the first name
            FirstName = txtFirstName.Text
            'get the last name
            LastName = txtLastName.Text
            'get the email address
            EMail = txtEMail.Text
            'try to send the password to the new user
            PasswordSent = SendPassword(FirstName, LastName, EMail, NewPassword)
            'if the password was sent ok
            If PasswordSent = True Then
                'stop the user changing their name
                txtFirstName.Enabled = False
                txtLastName.Enabled = False
                'stop the user changing their email address
                txtEMail.Enabled = False
                'disable the send password button
                btnPassword.Enabled = False
                'display the password text box
                txtPassword.Visible = True
                'display the create account button
                btnCreate.Visible = True
                'show further instructions
                lblError.Text = "DO NOT CLOSE THIS PAGE! An email has been sent to your account with your password.  To create your account type it into the box above."
            Else
                'show an error
                lblError.Text = "There was a problem sending your password.  Please check your email address and try again."
            End If
        Else
            'display the error message
            lblError.Text = ErrorMessage
        End If
    End Sub

    Protected Sub btnCreate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnCreate.Click
        'this event creates a new account so long as the user
        'enters the correct password to validate their email address
        '
        'var to store first name
        Dim FirstName As String
        'var to store last name
        Dim LastName As String
        'var to store email address
        Dim EMail As String
        'var to store password
        Dim Password As String
        'clear the error message label control
        lblError.Text = ""
        'get the first name
        FirstName = txtFirstName.Text
        'get the last name
        LastName = txtLastName.Text
        'get the email address
        EMail = txtEMail.Text
        'get the password
        Password = txtPassword.Text
        'if the internal password is the same as the one on the form
        If NewPassword = txtPassword.Text Then
            'create the account
            Call CreateAccount(FirstName, LastName, EMail, Password)
            'tell the user the account has been created
            lblError.Text = "Your account has been created."
            'disable the password text box
            txtPassword.Enabled = False
            'hide the create account button so they cannot press it again
            btnCreate.Visible = False
        Else
            'display an error message
            lblError.Text = "There was a problem sending your password.  Please check your email address and try again."
        End If
    End Sub

    Protected Sub btnDone_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDone.Click
        'redirect back to the main page
        Response.Redirect("Default.aspx")
    End Sub

    Function DetailsValid() As String
        'this function checks the details entered by the new user
        'and checks if they are valid
        'it returns any related error messages as a string
        '
        'var to store main error message
        Dim ErrorMessage As String
        'var to store email error message
        Dim EMailError As String
        'clear the error message
        ErrorMessage = ""
        'if the first name is blank then 
        If txtFirstName.Text = "" Then
            'store the error
            ErrorMessage = ErrorMessage & "You must enter your first name. "
        End If
        'if the last name is blank then 
        If txtLastName.Text = "" Then
            'store the error
            ErrorMessage = ErrorMessage & "You must enter your last name. "
        End If
        'check to see if the email is valid
        EMailError = ValidEMail(txtEMail.Text)
        'if there is an email related error then 
        If EMailError <> "" Then
            'store the error
            ErrorMessage = ErrorMessage & EMailError
        End If
        'return the error message
        Return ErrorMessage
    End Function

    Function ValidEMail(ByVal EMail As String) As String
        'this function checks to see if an email is in a valid format
        'any error messages are returned as a string
        'accepts one parameter EMail
        '
        'var to store the error message
        Dim ErrorMessage As String
        'clear the error message
        ErrorMessage = ""
        'check that the email address contains an @ symbol
        If InStr(EMail, "@") = 0 Then
            'store the error if missing
            ErrorMessage = ErrorMessage & "You must include an @ symbol in your email address. "
        End If
        'check that the email address contains an . symbol
        If InStr(EMail, ".") = 0 Then
            'store the error if missing
            ErrorMessage = ErrorMessage & "You must include a . symbol in your email address. "
        End If
        'if the email is blank
        If EMail = "" Then
            'stor the error message
            ErrorMessage = ErrorMessage & "Your email address cannot be blank. "
        End If
        'if the address has already been used
        If EMailInUse(EMail) = True Then
            'store the error message
            ErrorMessage = ErrorMessage & "This email address has already been used. "
        End If
        'return the error message
        Return ErrorMessage
    End Function

    Function EMailInUse(ByVal EMail As String) As Boolean
        'this function checks to see if an email address has already been used
        'it returns true or false
        'accepts one parameter EMail
        '
        'open a connection to the database table users selecting only records using this address
        Dim Users As New DatabaseTable("dvd.mdb", "select * from users where email='" & EMail & "'", "#PN", "#PW")
        'if there are no records
        If Users.Count = 0 Then
            'return false
            Return False
        Else
            'if at least one record found then return true
            Return True
        End If
    End Function

    Function SendPassword(ByVal FirstName As String, ByVal LastName As String, ByVal EMail As String, ByVal Password As String) As Boolean
        'this function sends the password for the new account to the user
        'if the email is sent ok then it returns true, else false
        'it accepts four parameters FirstName, LastName, EMail and Password
        '
        'create a new instance of the MyEmail object
        Dim AnEmail As New MyEMail
        'var to record success of email send
        Dim AllOk As Boolean
        'send the email to the user containing the password
        AllOk = AnEmail.SendEMail("noreply@dmu.ac.uk", EMail, "Your DVD swap shop password", FirstName & vbCrLf & " Your password is " & Password)
        'return the status of the action
        Return AllOk
    End Function

    Function GeneratePassword() As String
        'this function generates a new password
        'the password is returned as a string
        '
        'var to store the password
        Dim APassword As String
        'generate the password by calling GetWord twice concatenating the results
        APassword = GetWord() & GetWord()
        'return the password
        Return APassword
    End Function

    Function GetWord() As String
        'this function returns a single word from the file passwords.txt
        '
        'store the path of the application in DBPath
        Dim DbPath As String = System.AppDomain.CurrentDomain.BaseDirectory
        'create a connection to passwords.txt
        Dim MyFile As New System.IO.StreamReader(DbPath & "\passwords.txt")
        'declare a new arraylist for the words in the file
        Dim Passwords As New ArrayList
        'var to store the one word
        Dim AWord As String
        'var to store the random index of the selected word
        Dim PWNo As Integer
        'var to store the count of words in the list
        Dim WordCount As Integer
        'initialise the random number seed
        Randomize()
        'initialise the word var
        AWord = ""
        'while there are words to read in the text file
        While MyFile.Peek >= 0
            'read in a single line (word)
            AWord = MyFile.ReadLine
            'add the word to the array list
            Passwords.Add(AWord)
        End While
        'close the text file
        MyFile.Close()
        'get the number of words in the list
        WordCount = Passwords.Count - 1
        'generate a random number between 0 and no of words less one
        PWNo = Rnd() * WordCount
        'get the word at that index
        AWord = Passwords.Item(PWNo)
        'return the word
        Return AWord
    End Function

    Sub CreateAccount(ByVal FirstName As String, ByVal LastName As String, ByVal EMail As String, ByVal Password As String)
        'this sub creates a new account for the user
        'accepts four parameters FirstName LastName EMail and Password
        '
        'create a connection to the database table users
        Dim Users As New DatabaseTable("dvd.mdb", "select * from users", "#PN", "#PW")
        'store the first name in the new record object
        Users.NewRecord.Item("FirstName") = FirstName
        'store the last name in the new record object
        Users.NewRecord.Item("LastName") = LastName
        'stor the email in the new record object
        Users.NewRecord.Item("EMail") = EMail
        'store the password
        Users.NewRecord.Item("UserPassword") = Password
        'add the new record
        Users.AddNewRecord()
        'save the changes (the new user is added to the database)
        Users.SaveChanges()
    End Sub
End Class
